// $Id: CHtmlString.cpp,v 1.5 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CHtmlString.hpp"
using Exponent::Basics::CHtmlString;
#ifdef WIN32
	#include "Shellapi.h"
#endif

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CHtmlString, CCountedObject);

//	===========================================================================
const char *CHtmlString::CHTML_STRING_WEB_LOCATION = "http://";

//	===========================================================================
const char *CHtmlString::CHTML_STRING_FILE_LOCATION = "file://";

//	===========================================================================
CHtmlString::CHtmlString(const CSystemString &string) : CSystemString(string)
{
	EXPONENT_CLASS_CONSTRUCTION(CHtmlString);
	// Nothing to do
}

//	===========================================================================
CHtmlString::CHtmlString(const CHtmlString &string) : CSystemString(string.getString())
{
	EXPONENT_CLASS_CONSTRUCTION(CHtmlString);
	// Nothing to do
}

//	===========================================================================
CHtmlString::CHtmlString(const char *string) : CSystemString(string)
{
	EXPONENT_CLASS_CONSTRUCTION(CHtmlString);
	// Nothing to do
}

//	===========================================================================
CHtmlString::~CHtmlString()
{
	EXPONENT_CLASS_DESTRUCTION(CHtmlString);
	// Nothing to do
}

//	===========================================================================
bool CHtmlString::isFileLocation()
{
	return (this->getSubString(0, 5) == CHTML_STRING_FILE_LOCATION);
}

//	===========================================================================
bool CHtmlString::isWebLocation()
{
	return (this->getSubString(0, 5) == CHTML_STRING_WEB_LOCATION);
}

//	===========================================================================
void CHtmlString::loadInBrowser()
{
	if (!(this->isFileLocation() || this->isWebLocation()))
	{
		this->appendLocation();
	}

#ifdef WIN32
	ShellExecute(NULL, "open", m_string, NULL, NULL, SW_SHOWNORMAL);
#else
	ICInstance instance;
	long start = 0;
	long end   = strlen(m_string);
	if (ICStart(&instance, '????') == noErr)
	{
		ICLaunchURL(instance, 0, m_string, strlen(m_string), &start, &end);
		ICStop(instance);
	}
#endif
}

//	===========================================================================
void CHtmlString::appendLocation(const bool isHttp)
{
	CString text(m_string);
	if (isHttp)
	{
		this->setString(CHTML_STRING_WEB_LOCATION);
	}
	else
	{
		this->setString(CHTML_STRING_FILE_LOCATION);
	}
	this->appendString(text);
}